#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Template-image python-fu for Gimp 2.6
# Copyright Raymond Ostertag 2007-2009
# Licence GPL

# Version 2.1
# - ported to gimp-2.6
# - added valid images rgb* and gray*
# Version 2.0
# - use gettext 
# Version 1.0
# - initial release

# Installation : put the template-image.py file in your $HOME/.gimp-2.n/plug-ins.
# On Linux and Mac OSX the file must be executable.
# Documentation : http://www.gimp.org/docs/python/index.html

from gimpfu import *

# i18n
#
import gettext
locale_directory = gimp.locale_directory
gettext.install( "gimp20-template" , locale_directory, unicode=True )

#         
Template_image_help = _("Add N empty layers in an existing Image.")                                
Template_image_description = _("Python-fu template for Gimp 2.6.")+" "+Template_image_help

# main
#                                         
def python_fu_template_image( inImage, inDrawable, NbLayer, FillType  ):
  for i in range( NbLayer ) :
    new_layer = gimp.Layer(inImage, "New Layer", inImage.width, inImage.height, RGBA_IMAGE, 100, NORMAL_MODE)
    inImage.add_layer(new_layer, 0)
    new_layer.fill( FillType )
  gimp.displays_flush( )

register(
  "python-fu-template-image",
  Template_image_description,
  Template_image_help,
  "Raymond Ostertag",
  "GPL License",
  "2007-2009",
  _("Template-image"),
  "RGB*,GRAY*",
  [
    (PF_IMAGE, "inImage", "Input image", None),
    (PF_DRAWABLE, "inLayer", "Input drawable", None),
    (PF_INT, "NbLayer", _("Number of new layers"), 2),
    (PF_RADIO, "FillType", _("Fill Type"), 3,
      ((_("Foreground"), 0), 
      (_("Background"), 1), 
      (_("White"), 2), 
      (_("Transparent"), 3), 
      (_("Pattern"), 4))
    ),
  ],
  [],
  python_fu_template_image,
  menu="<Image>/TEST/Szablony",  # w oryginale <Image>/Layer"
  domain=("gimp20-template", locale_directory) 
  )

main()
